﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;
using VIMT.VIASchedulingService.Messages;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.Links;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.MakeAppointment
{
    public class LoginProviderSideToEcStep : FilterBase<MakeAppointmentStateObject>
    {
        public override void Execute(MakeAppointmentStateObject state)
        {
            if (state.AppointmentType == AppointmentType.STORE_FORWARD)
                return;
            if (string.IsNullOrEmpty(state.VistaFakeResponseType))
            {
                state.ProEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_userId = "FAKE_ProviderLogin";
                return;
            }
            var loginId = VistaMapperHelper.GetViaLoginId(state.ProLoginRequest, Side.Provider);
            state.ProEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_userId = loginId;
        }
    }
}
